<?php
/**
 * Created by PhpStorm.
 * User: sunusi
 * Date: 2019-02-11
 * Time: 21:02
 */



//generate config functions based on the configuration name from the database
function getConfig($configName)
{
    $query = new db();
    $config = $query->getOne("
      SELECT * 
      FROM udut_configurations 
      WHERE configName = '" . $configName . "'
    ");
    $configValue = $config["configValue"];
    return $configValue;
}
//generate the total monthly revenue to be used in the ppp sharing formula
function getTotalMonthlyRevenue($month)
{
    $query = new db();
    //fetch revenue according to month
    $sql = $query->getAll("
        SELECT udut_payments.*,
               udut_scan_types.*
        FROM udut_payments
        JOIN udut_scan_types
        ON udut_payments.typeId = udut_scan_types.typeId
        WHERE udut_payments.paymentDateAdded LIKE '%" . $month . "%'
    ");
    $totalAmount = 0;
    foreach ($sql as $revenue) {
        $totalAmount = $totalAmount + $revenue['typeAmount'];
    }
    return $totalAmount;
}
//generate total monthly revenue after removing the fixed running cost
function getTotalAfterRunningCost($month){
    $runningCost = getConfig("runningCost");
    $totalRevenue = getTotalMonthlyRevenue($month);
    $afterRunningCost = $totalRevenue - $runningCost;
    return $afterRunningCost;
}
//generate hospital percentage from function getTotalAfterRunningCost()
function getHospitalPercentage($month){
    $hospitalPercentage = getConfig("hosAccPer");
    $totalRevenue = getTotalAfterRunningCost($month);
    $hospitalRevenue = ($hospitalPercentage * $totalRevenue) / 100;
    return $hospitalRevenue;
}
//generate management percentage from function getTotalAfterRunningCost()
function getManagementPercentage($month){
    $managementPercentage = getConfig("manAccPer");
    $totalRevenue = getTotalAfterRunningCost($month);
    $managementRevenue = ($managementPercentage * $totalRevenue) / 100;
    return $managementRevenue;
}
//generate total revenue after deducting hospital and management percentage
function getTotalAfterHnMPercentage($month){
    $hospitalPercentage = getHospitalPercentage($month);
    $managementPercentage = getManagementPercentage($month);
    $deducted = $hospitalPercentage + $managementPercentage;
    $totalRevenue = getTotalAfterRunningCost($month) - $deducted;
    return $totalRevenue;
}
//generate foresight percentage after hospital and management percentage
function getForesightPercentage($month){
    $foresightPercentage = getConfig("foresightPer");
    $afterHnM = getTotalAfterHnMPercentage($month);
    $totalRevenue = ($foresightPercentage * $afterHnM) / 100;
    return $totalRevenue;
}
//generate kalifa percentage as remaining percent of the foresight
function getKalifaPercentage($month){
    $kalifaPercentage = getConfig("kalifaPer");
    $afterHnM = getTotalAfterHnMPercentage($month);
    $totalRevenue = ($kalifaPercentage * $afterHnM) / 100;
    return $totalRevenue;
}
//splitting hospital 30% percentage into the following functions
//generate hospital account percentage
function getHospitalAccountPercentage($month){
    $hospitalAccount = getConfig("hosHosAccPer");
    $hospitalPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($hospitalAccount * $hospitalPercentage) / 100;
    return $totalRevenue;
}
//generate administration fee
function getAdministrationFeePercentage($month){
    $administrationFee = getConfig("hosAdmFee");
    $hospitalPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($administrationFee * $hospitalPercentage) / 100;
    return $totalRevenue;
}
//generate CMD percentage
function getCMDPercentage($month){
    $hospitalCMD = getConfig("hosCMD");
    $hospitalPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($hospitalCMD * $hospitalPercentage) / 100;
    return $totalRevenue;
}
//generate Dr. Admin percentage
function getDrAdminPercentage($month){
    $hospitalDrAdmin = getConfig("hosDrAdm");
    $hospitalPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($hospitalDrAdmin * $hospitalPercentage) / 100;
    return $totalRevenue;
}
//generate radiology department percentage
function getRadiologyDepartmentPercentage($month){
    $hospitalRadiologyDepartment = getConfig("hosRadDep");
    $hospitalPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($hospitalRadiologyDepartment * $hospitalPercentage) / 100;
    return $totalRevenue;
}

