<?php
namespace FileRun;
Lang::setSection('Admin: Users');

$adminOver = false;

if (!Perms::isSuperUser()) {
	if (!Perms::isIndependentAdmin()) {
		$adminOver = Perms::getOne('admin_over');
		if ($adminOver == '') {
			die(Lang::t('You are not allowed to manage user accounts.'));
		}
	}
}

$usd = Users::getTable();

if (!Perms::isSuperUser()) {//super user can manage all users
	if ($adminOver != '-ALL-') {
		if (!Perms::isIndependentAdmin()) { //only non-indep admins can manage groups of users
			$list = [];
			if (is_array($adminOver)) {
				foreach ($adminOver as $key => $gid) {
					$list = array_merge($list, UserGroups::selectUsersByGroup($gid));
				}
			}
			$list = array_unique($list);
			$filterCriteria[] = ["USR.id", "IN", "('".implode("','", $list)."')"];
		}
	}
}

if (Perms::isIndependentAdmin()) { //indep admins manage only their own created users
	$filterCriteria[] = ["USR.owner", "=", $auth->currentUserInfo['id']];
}


if (!Perms::isSuperUser()) {
	$filterCriteria[] = ["USR.id", "!=", 1];
}

if ($_REQUEST['limit']) {
	$paging['perPage'] = \S::fromHTML($_REQUEST['limit']);
} else {
	$paging['perPage'] = 20;
}
if ($_REQUEST['start']) {
	$paging['pageOffset'] = \S::fromHTML($_REQUEST['start']);
} else {
	$paging['pageOffset'] = 0;
}
if ($_REQUEST['sort']) {
	$paging['sort'] = \S::fromHTML($_REQUEST['sort']);
	$paging['sort_dir'] = \S::fromHTML($_REQUEST['dir']);
	if ($paging['sort'] == 'homefolder') {
		$paging['sort'] = 'PERM.homefolder';
	}
	$sort = [$paging['sort']  => $paging['sort_dir']];
} else {
	$sort = ["USR.registration_date" => "DESC"];
}


$usd->table = "df_users AS USR LEFT JOIN df_users_permissions AS PERM ON USR.id=PERM.uid LEFT JOIN df_modules_user_roles AS R ON PERM.role = R.id";


$filterCriteria[] = ["USR.id", "=", "PERM.uid"];


$filterCriteria[] = [
	[
		["PERM.role", "=", "0", "type" => "AND"],
		["PERM.role", "IS", "NULL", "type" => "OR"]
	],
	[
		[
			["PERM.role", "!=", "0", "type" => "OR"],
			["PERM.role", "IS NOT", "NULL", "type" => "AND"]
		],
		["PERM.role", "=", "R.id", "type" => "AND"]
	]
];


if (Perms::isSimpleAdmin()) {
	$noAdminByRole = [
		[
			["PERM.role", "!=", "0", "type"=>"OR"],
			["PERM.role", "IS NOT", "NULL", "type"=>"AND"]
		],
		["R.admin_type", "=", "''"],
	];

	$filterCriteria[] = [
		[
			["PERM.admin_type", "=", "''", "type" => "AND"],
			$noAdminByRole
		]
	];
}

/*
if ($onlyIndep) {
	$indepByRole = [
		[
			["PERM.role", "!=", "0", "type"=>"OR"],
			["PERM.role", "IS NOT", "NULL", "type"=>"AND"],
		],
		["R.admin_type", "=", "'indep'"],
	];
	$filterCriteria[] = [
		[
			["PERM.admin_type", "=", "'indep'", "type" => "AND"],
			$indepByRole
		]
	];
}
*/

if (isset($_POST['rid'])) {
	$filterCriteria[] = ["PERM.role", "=", $usd->q($_POST['rid'])];
}

if (isset($_GET['filter_deactivated'])) {
	$filterCriteria[] = ["USR.activated", "=", "0"];
}

if ($_POST['search']) {
	$search = \S::fromHTML($_POST['search']);
	$filterCriteria[] = [
		["USR.username", "LIKE", $usd->q('%'.$search.'%'), "AND"],
		["USR.name", "LIKE", $usd->q('%'.$search.'%'), "OR"],
        ["USR.name2", "LIKE", $usd->q('%'.$search.'%'), "OR"],
		["USR.email", "LIKE", $usd->q('%'.$search.'%'), "OR"],
		["USR.company", "LIKE", $usd->q('%'.$search.'%'), "OR"]
	];
}


$columns = "USR.*, (PERM.admin_type != '' OR R.admin_type !='' OR USR.id = 1) AS admin_type";

$listOfUsers = $usd->select($columns, $filterCriteria, $sort, $paging['perPage'], $paging['pageOffset'], true);
$usd->table = Users::$table;

$foundRows = $db->GetOne("SELECT FOUND_ROWS()");
$paging['total'] = $foundRows;


if (Perms::isSuperUser()) {//count created users
	foreach ($listOfUsers as $key => $val) {
		$listOfUsers[$key]['perms'] = Perms::getPerms($val['id']);
		if ($listOfUsers[$key]['perms']['admin_type'] == "indep") {
			$listOfUsers[$key]['count_owned_users'] = $usd->selectOneCol("COUNT(id)", array("owner" , "=", $usd->q($val['id'])));
		}
	}
}

$rows = array();
$countOwned = 0;
$countWithRoles = 0;
foreach ($listOfUsers as $usr) {
	$userInfo = Users::getInfo($usr['id']);
	if ($userInfo['owner'] && Perms::isSuperUser()) {
		$ownerInfo = Users::getInfo($userInfo['owner']);
		$usr['owner'] = $ownerInfo['name'];
	}
	$usr['name'] = \S::safeHTML($usr['name']);

	$perms = Perms::getPerms($usr['id']);
	if (!Perms::isIndependentAdmin()) {
		if (!@is_dir($perms['homefolder'])) {
			$perms['homefolder'] = '<span style="color:red">'.$perms['homefolder'].'</span>';
		}
	}
	
	if (!isEmptyMySQLDate($userInfo['last_login_date']) && $userInfo['last_login_date'] != '1970-01-01 01:00:00') {
		$userInfo['last_login_date_formatted'] = date(Lang::t('Date Format: Last login'), Utils\Date::MySQLDateToUnix($userInfo['last_login_date']));
	}
	if (!isEmptyMySQLDate($userInfo['registration_date']) && $userInfo['registration_date'] != '1970-01-01 01:00:00') {
		$userInfo['registration_date_formatted'] = date(Lang::t('Date Format: Registration date'), Utils\Date::MySQLDateToUnix($userInfo['registration_date']));
	}
	if (!isEmptyMySQLDate($userInfo['expiration_date'])) {
		$userInfo['expiration_date_formatted'] = date(Lang::t('Date Format: Expiration date'), Utils\Date::MySQLDateToUnix($userInfo['expiration_date']));
	} else {

		$userInfo['expiration_date_formatted'] = '';

		if (UserGuests::isGuest($perms['role'])) {
			$expDate = UserGuests::getExpirationDate($userInfo);
			if ($expDate) {
				$userInfo['expiration_date_formatted'] = $expDate->format(Lang::t('Date Format: Expiration date'));
			}
		}
	}

	$icon = '<img src="a/?uid='.$usr['id'].'" class="avatar-s" />';


	if ($perms['role']) {
		$roleInfo = UserRoles::getInfo($perms['role']);
		$role = $roleInfo['name'];
	} else {
		$role = '';
	}

	$fName = \S::forHTML($usr['name']);
	$lName = \S::forHTML($usr['name2']);
	$uName = $usr['username'];
	if (!$usr['activated']) {
		$fName = '<span style="color:gray">'.$fName.'</span>';
		$lName = '<span style="color:gray">'.$lName.'</span>';
		$uName = '<span style="color:gray">'.$uName.'</span>';
	}

	if ($usr['owner']) {$countOwned++;}
	if ($role) {$countWithRoles++;}

	$rows[] = [
		'avatar' => $icon,
		'owner' => $usr['owner'] ? \S::forHTML(\S::safeHTML($usr['owner'])) : '',
		'name' => $fName,
        'name2' => $lName,
		'username' => $uName,
		'company' => \S::forHTML(\S::safeHTML($usr['company'])),
		'description' => \S::forHTML(\S::safeHTML($usr['description'])),
		'email' => \S::forHTML(\S::safeHTML($usr['email'])),
		'homefolder' => $perms['homefolder'],
		'role' => $role,
		'registration_date' => $userInfo['registration_date_formatted'],
		'expiration_date' => $userInfo['expiration_date_formatted'],
		'last_login_date' => $userInfo['last_login_date_formatted'],
		'activated' => $userInfo['activated'] ? '': Lang::t('Yes'),
		'id' => $usr['id']
	];
}

$returnedFields = [
	['header' => '&nbsp;', 'name' => 'avatar',  'width' => 38, 'resizable' => false],
	['header' => Lang::t('First name'), 'name' => 'name',  'width' => 65, 'sortable' => true],
	['header' => Lang::t('Last name'), 'name' => 'name2',  'width' => 65, 'sortable' => true],
	['header' => Lang::t('Username'), 'name' => 'username', 'width' => 80, 'sortable' => true],
	['header' => Lang::t('E-mail address'), 'name' => 'email', 'width' => 120, 'sortable' => true],
];

if (!\FileRun::isFree()) {
	if (Perms::isSuperUser() && $countOwned) {
		$returnedFields[] = ['header' => Lang::t('Parent user'), 'name' => 'owner', 'width' => 70, 'sortable' => true];
	}
	if ($countWithRoles) {
		$returnedFields[] = ['header' => Lang::t('Role'), 'name' => 'role', 'width' => 70, 'sortable' => true];
	}
}
if (!Perms::isIndependentAdmin()) {
	$returnedFields[] = ['header' => Lang::t('Home folder'), 'name' => 'homefolder', 'width' => 200, 'sortable' => true];
}
if (!\FileRun::isFree()) {
	$returnedFields[] = ['header' => Lang::t('Registration date'), 'name' => 'registration_date', 'width' => 80, 'sortable' => true];
	$returnedFields[] = ['header' => Lang::t('Expires'), 'name' => 'expiration_date', 'width' => 80, 'sortable' => true];
}
$returnedFields[] = ['header' => Lang::t('Last login'), 'name' => 'last_login_date', 'width' => 110, 'sortable' => true];
if (!\FileRun::isFree()) {
	$returnedFields[] = ['header' => Lang::t('Company'), 'name' => 'company', 'width' => 70, 'sortable' => true];
	$returnedFields[] = ['header' => Lang::t('Note'), 'name' => 'description', 'sortable' => true];
}
$returnedFields[] = ['header' => Lang::t('Disabled'), 'name' => 'activated', 'width' => 70, 'sortable' => true];
$returnedFields[] = ['header' => Lang::t('ID'), 'name' => 'id', 'width' => 40, 'sortable' => true];

jsonOutput([
	'success' => true,
	'metaData' => [
		'fields' => $returnedFields,
		'root' => 'rows',
		'totalProperty' => 'totalCount'
	],
	'totalCount' => $paging['total'],
	'rows' => $rows
]);